//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Text;
using System.Net;
using System.Net.Sockets;

class Listener
{
	public static void Main()
	{
		Console.WriteLine("Gotowy do przetwarzania da...");
		ProcessRequests();	
	}

	public static void ProcessRequests()
	{
		TcpListener client = new TcpListener(5000);
		client.Start();
		// Socket s = client.AcceptSocket();
		TcpClient s = client.AcceptTcpClient();

		byte[] responseData = new byte[128];
		bool continueProcessing = true;

		NetworkStream stream = s.GetStream();
		string message;
		int bytesRead;

		while(continueProcessing)
		{	
			try
			{
				bytesRead = stream.Read(responseData, 0, responseData.Length);
				if(bytesRead == 0)
				{
					// Klient rozczy si
					continueProcessing = false;
					break;
				}
				else
				{
					message = Encoding.Unicode.GetString(responseData, 0, bytesRead);

					if(message == "quit")
					{
						continueProcessing = false;
						break;
					}
					else
					{
						Console.WriteLine("Otrzymana wiadomo to " + message);
					}
				}
			}
			catch(Exception ex)
			{
				Console.WriteLine(ex.ToString());
			}
		}

		client.Stop();
	}
}
